import {INotebookGetTravelerService} from 'server/services/NotebookService/types/INotebookGetTravelerService';
import {INotebookGetPassengersService} from 'server/services/NotebookService/types/INotebookGetPassengersService';
import {INotebookGetPassengerService} from 'server/services/NotebookService/types/INotebookGetPassengerService';
import {INotebookGetPassengerDocumentsService} from 'server/services/NotebookService/types/INotebookGetPassengerDocumentsService';
import {INotebookGetPassengerDocumentService} from 'server/services/NotebookService/types/INotebookGetPassengerDocumentService';
import {INotebookGetPassengerBonusCardsService} from 'server/services/NotebookService/types/INotebookGetPassengerBonusCardsService';
import {INotebookGetPassengerBonusCardService} from 'server/services/NotebookService/types/INotebookGetPassengerBonusCardService';
import {INotebookGetDocumentTypesService} from 'server/services/NotebookService/types/INotebookGetDocumentTypesService';
import {INotebookCreateOrUpdateTravelerService} from 'server/services/NotebookService/types/INotebookCreateOrUpdateTravelerService';
import {INotebookCreatePassengerService} from 'server/services/NotebookService/types/INotebookCreatePassengerService';
import {INotebookEditPassengerService} from 'server/services/NotebookService/types/INotebookEditPassengerService';
import {INotebookDeletePassengerService} from 'server/services/NotebookService/types/INotebookDeletePassengerService';
import {INotebookEditPassengerDocumentService} from 'server/services/NotebookService/types/INotebookEditPassengerDocumentService';
import {INotebookCreatePassengerDocumentService} from 'server/services/NotebookService/types/INotebookCreatePassengerDocumentService';
import {INotebookDeletePassengerDocumentService} from 'server/services/NotebookService/types/INotebookDeletePassengerDocumentService';
import {INotebookCreatePassengerBonusCardService} from 'server/services/NotebookService/types/INotebookCreatePassengerBonusCardService';
import {INotebookEditPassengerBonusCardService} from 'server/services/NotebookService/types/INotebookEditPassengerBonusCardService';
import {INotebookDeletePassengerBonusCardService} from 'server/services/NotebookService/types/INotebookDeletePassengerBonusCardService';
import {INotebookSaveTravelerAndPassengersService} from 'server/services/NotebookService/types/INotebookSaveTravelerAndPassengersService';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {INotebookService} from 'server/services/NotebookService/NotebookService';

export class NotebookBrowserProvider
    extends BrowserHttpClient
    implements INotebookService
{
    constructor() {
        super({baseURL: '/api/notebook'});
    }

    getTraveler: INotebookGetTravelerService = params =>
        this.get('getTraveler', {params});

    createOrUpdateTraveler: INotebookCreateOrUpdateTravelerService = params =>
        this.post('createOrUpdateTraveler', params);

    getPassengers: INotebookGetPassengersService = params =>
        this.get('getPassengers', {params});

    getPassenger: INotebookGetPassengerService = params =>
        this.get('getPassenger', {params});

    createPassenger: INotebookCreatePassengerService = params =>
        this.post('createPassenger', params);

    editPassenger: INotebookEditPassengerService = params =>
        this.put('editPassenger', params);

    deletePassenger: INotebookDeletePassengerService = params =>
        this.delete('deletePassenger', {params});

    getPassengerDocuments: INotebookGetPassengerDocumentsService = params =>
        this.get('getPassengerDocuments', {params});

    getPassengerDocument: INotebookGetPassengerDocumentService = params =>
        this.get('getPassengerDocument', {params});

    createPassengerDocument: INotebookCreatePassengerDocumentService = params =>
        this.post('createPassengerDocument', params);

    editPassengerDocument: INotebookEditPassengerDocumentService = params =>
        this.put('editPassengerDocument', params);

    deletePassengerDocument: INotebookDeletePassengerDocumentService = params =>
        this.delete('deletePassengerDocument', {params});

    getPassengerBonusCards: INotebookGetPassengerBonusCardsService = params =>
        this.get('getPassengerBonusCards', {params});

    getPassengerBonusCard: INotebookGetPassengerBonusCardService = params =>
        this.get('getPassengerBonusCard', {params});

    createPassengerBonusCard: INotebookCreatePassengerBonusCardService =
        params => this.post('createPassengerBonusCard', params);

    editPassengerBonusCard: INotebookEditPassengerBonusCardService = params =>
        this.put('editPassengerBonusCard', params);

    deletePassengerBonusCard: INotebookDeletePassengerBonusCardService =
        params => this.delete('deletePassengerBonusCard', {params});

    getDocumentTypes: INotebookGetDocumentTypesService = () =>
        this.get('getDocumentTypes');

    saveTravelerAndPassengers: INotebookSaveTravelerAndPassengersService =
        params => this.post('saveTravelerAndPassengers', params);
}

export const notebookBrowserProvider = new NotebookBrowserProvider();
