import {IDependencies} from 'server/getContainerConfig';
import {INotifierService} from 'server/services/NotifierService/NotifierService';

import {getProvider} from 'serviceProvider/core';
import {notifierBrowserProvider} from 'serviceProvider/notifier/notifierBrowserProvider';

export const notifierService = {
    provider(container?: IDependencies): INotifierService {
        return getProvider<'notifierService', INotifierService>(
            notifierBrowserProvider,
            'notifierService',
        )(container);
    },
};
