import {IOrdersService} from 'server/services/OrdersService/types/IOrdersService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';
import {ordersBrowserProvider} from 'serviceProvider/orders/ordersBrowserProvider';

export const orders = {
    provider(container?: IDependencies): IOrdersService {
        return getProvider<'ordersService', IOrdersService>(
            ordersBrowserProvider as any, // Нужно перенести в ordersBrowserProvider все методы, которые есть в сервисе
            'ordersService',
        )(container);
    },
};
