import {IGetOrderHappyPageServiceParams} from 'server/services/OrdersService/types/IGetOrderHappyPageServiceParams';
import {IOrdersIOrdersGetUserPromoAttributesApiResponse} from 'server/api/OrdersAPI/types/IOrdersIOrdersGetUserPromoAttributesApiResponse';
import {TGetOrderHappyPageServiceResponse} from 'server/services/OrdersService/types/TGetOrderHappyPageServiceResponse';
import {IOrdersService} from 'server/services/OrdersService/types/IOrdersService';
import {
    ICreateOrderAuthorizationResponse,
    TCreateOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICreateOrderAuthorization';
import {TGetPaymentTestContextTokenParams} from 'server/api/OrdersAPI/types/TGetPaymentTestContextTokenParams';
import IGetPaymentTestContextTokenResponse from 'server/api/OrdersAPI/types/IGetPaymentTestContextTokenResponse';
import {
    ICheckOrderAuthorizationResponse,
    TCheckOrderAuthorizationRequestParams,
} from 'server/api/OrdersAPI/types/ICheckOrderAuthorization';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class OrdersBrowserProvider
    extends BrowserHttpClient
    implements IOrdersService
{
    constructor() {
        super({baseURL: '/api/orders'});
    }

    getOrderHappyPage = (
        params: IGetOrderHappyPageServiceParams,
    ): Promise<TGetOrderHappyPageServiceResponse> => {
        return this.get('getOrderHappyPage', {params});
    };

    getUserPromoAttributes =
        (): Promise<IOrdersIOrdersGetUserPromoAttributesApiResponse> => {
            return this.get('getUserPromoAttributes');
        };

    checkOrderAuthorization = (
        params: TCheckOrderAuthorizationRequestParams,
    ): Promise<ICheckOrderAuthorizationResponse> => {
        return this.get('checkOrderAuthorization', {params});
    };

    createOrderAuthorization = (
        params: TCreateOrderAuthorizationRequestParams,
    ): Promise<ICreateOrderAuthorizationResponse> => {
        return this.post('createOrderAuthorization', params);
    };

    getPaymentTestContextToken = (
        params: TGetPaymentTestContextTokenParams,
    ): Promise<IGetPaymentTestContextTokenResponse> => {
        return this.get('paymentTestContextToken', {params});
    };
}

export const ordersBrowserProvider = new OrdersBrowserProvider();
