import IGetHotelsSuggestsResponse from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsResponse';
import IGetAviaSearchHistoryResponse from 'server/api/PersonalizationApi/types/IGetAviaSearchHistoryResponse';
import IGetHotelsSuggestsRequestParams from 'server/api/PersonalizationApi/types/IGetHotelsSuggestsRequestParams';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {
    IPersonalizationService,
    IGetAviaSearchHistoryServiceParams,
} from 'server/services/PersonalizationService/PersonalizationService';

export class BrowserPersonalizationProvider
    extends BrowserHttpClient
    implements IPersonalizationService
{
    constructor() {
        super({baseURL: '/api/personalization/'});
    }

    getHotelsSuggests = async (
        params: IGetHotelsSuggestsRequestParams,
    ): Promise<IGetHotelsSuggestsResponse> => {
        return this.get<IGetHotelsSuggestsResponse>(`/getHotelsSuggests`, {
            params,
        });
    };

    getAviaSearchHistory = async (
        params: IGetAviaSearchHistoryServiceParams,
    ): Promise<IGetAviaSearchHistoryResponse> => {
        return this.get<IGetAviaSearchHistoryResponse>(
            `/getAviaSearchHistory`,
            {
                params,
            },
        );
    };
}

export const browserPersonalizationProvider =
    new BrowserPersonalizationProvider();
