import {IPersonalizationService} from 'server/services/PersonalizationService/PersonalizationService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserPersonalizationProvider} from './browserPersonalizationProvider';

export const personalization = {
    provider(container?: IDependencies): IPersonalizationService {
        return getProvider<'personalizationService', IPersonalizationService>(
            browserPersonalizationProvider,
            'personalizationService',
        )(container);
    },
};
