import {IRaspService} from 'server/services/RaspService/RaspService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';
import {raspBrowserProvider} from 'serviceProvider/rasp/raspBrowserProvider';

export const rasp = {
    provider(container?: IDependencies): IRaspService {
        return getProvider<'raspService', IRaspService>(
            raspBrowserProvider,
            'raspService',
        )(container);
    },
};
