import {IRaspParseContextService} from 'server/services/RaspService/types/IRaspParseContextService';
import {IRaspGetTrainOrderSegmentService} from 'server/services/RaspService/types/IRaspGetTrainOrderSegmentService';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IRaspService} from 'server/services/RaspService/RaspService';

export class RaspBrowserProvider
    extends BrowserHttpClient
    implements IRaspService
{
    constructor() {
        super({baseURL: '/api/trains'});
    }

    /**
     * Получение информации о точках отправления и прибытия для жд поиска.
     */
    parseContext: IRaspParseContextService = params =>
        this.get('parse-context', {params});

    getTrainOrderSegment: IRaspGetTrainOrderSegmentService = params =>
        this.get('orderSegment', {params});
}

export const raspBrowserProvider = new RaspBrowserProvider();
