import {ISimpleTextReview} from 'types/common/ISimpleTextReview';
import {IReviewsGetTrainsReviewsApiParams} from 'server/api/ReviewsApi/types/IReviewsGetTrainsReviewsApiParams';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IReviewsService} from 'server/services/ReviewsService/ReviewsService';

export class BrowserReviewsProvider
    extends BrowserHttpClient
    implements IReviewsService
{
    constructor() {
        super({baseURL: '/api/reviews/'});
    }

    getTrainsReviews = (
        params: IReviewsGetTrainsReviewsApiParams,
    ): Promise<ISimpleTextReview[]> => {
        return this.get<ISimpleTextReview[]>('getTrainsReviews', {params});
    };
}

export const browserReviewsProvider = new BrowserReviewsProvider();
