import {IDependencies} from 'server/getContainerConfig';
import {IReviewsService} from 'server/services/ReviewsService/ReviewsService';

import {getProvider} from 'serviceProvider/core';
import {browserReviewsProvider} from 'serviceProvider/reviews/browserReviewsProvider';

export const reviewsProvider = {
    provider(container?: IDependencies): IReviewsService {
        return getProvider<'reviewsService', IReviewsService>(
            browserReviewsProvider,
            'reviewsService',
        )(container);
    },
};
