import {
    IMetaArticle,
    IGetContextPageArticle,
    IGetContextPageTag,
} from 'server/api/TemplatorApi/types/IGetContextPageResponse';
import {IGetTagRequestParams} from 'server/services/TemplatorService/types/IGetTagRequestParams';
import {IGetArticleRequestParams} from 'server/services/TemplatorService/types/IGetArticleRequestParams';
import {IGetRootMetaRequestParams} from 'server/services/TemplatorService/types/IGetRootMetaRequestParams';
import {IGetArticlesRequestParams} from 'server/services/TemplatorService/types/IGetArticlesRequestParams';
import {IGetTagsListRequestParams} from 'server/services/TemplatorService/types/IGetTagsListRequestParams';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {ITemplatorService} from 'server/services/TemplatorService/TemplatorService';

export class BrowserTemplatorProvider
    extends BrowserHttpClient
    implements ITemplatorService
{
    constructor() {
        super({baseURL: '/api/templator/'});
    }

    getRootMeta = async (
        params: IGetRootMetaRequestParams,
    ): Promise<IMetaArticle> =>
        this.get<IMetaArticle>(`/getRootMeta`, {
            params,
        });

    getArticle = async (
        params: IGetArticleRequestParams,
    ): Promise<IGetContextPageArticle | null> =>
        this.get<IGetContextPageArticle | null>(`/getArticle`, {
            params,
        });

    getTagsList = async (
        params: IGetTagsListRequestParams,
    ): Promise<IGetContextPageTag[]> =>
        this.get<IGetContextPageTag[]>('/getTagsList', {params});

    getTagInfo = async (
        params: IGetTagRequestParams,
    ): Promise<IGetContextPageTag> =>
        this.get<IGetContextPageTag>('/getTagInfo', {
            params,
        });
    getArticles = async (
        params: IGetArticlesRequestParams,
    ): Promise<IGetContextPageArticle[]> =>
        this.get<IGetContextPageArticle[]>(`/getArticles`, {params});
}

export const browserTemplatorProvider = new BrowserTemplatorProvider();
