import {ITemplatorService} from 'server/services/TemplatorService/TemplatorService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserTemplatorProvider} from './browserTemplatorProvider';

export const templator = {
    provider(container?: IDependencies): ITemplatorService {
        return getProvider<'templatorService', ITemplatorService>(
            browserTemplatorProvider,
            'templatorService',
        )(container);
    },
};
