import ILevelTravelService from 'server/services/LevelTravelService/types/ILevelTravelService';
import {
    IAutocompleteParams,
    TAutocompleteResponse,
    IGetAvailableCountriesParams,
    TGetAvailableCountriesResponse,
    IGetCountriesParams,
    IGetCountriesResponse,
    IGetDeparturesParams,
    IGetDeparturesResponse,
    IGetFlightsAndNightsParams,
    IGetFlightsAndNightsResponse,
    IGetRedirectParams,
    IGetRedirectResponse,
} from 'server/api/LevelTravelApi/types';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class LevelTravelProvider
    extends BrowserHttpClient
    implements ILevelTravelService
{
    constructor() {
        super({baseURL: '/api/levelTravel/'});
    }

    getFlightsAndNights = (
        params: IGetFlightsAndNightsParams,
    ): Promise<IGetFlightsAndNightsResponse> =>
        this.get<IGetFlightsAndNightsResponse>('getFlightsAndNights', {params});

    autocomplete = (
        params: IAutocompleteParams,
    ): Promise<TAutocompleteResponse> =>
        this.get<TAutocompleteResponse>('autocomplete', {params});

    getAvailableCountries = (
        params: IGetAvailableCountriesParams,
    ): Promise<TGetAvailableCountriesResponse> =>
        this.get<TGetAvailableCountriesResponse>('getAvailableCountries', {
            params,
        });

    getCountries = (
        params: IGetCountriesParams,
    ): Promise<IGetCountriesResponse> =>
        this.get<IGetCountriesResponse>('getCountries', {params});

    getRedirect = (params: IGetRedirectParams): Promise<IGetRedirectResponse> =>
        this.get<IGetRedirectResponse>('getRedirect', {params});

    getDepartures = (
        params: IGetDeparturesParams,
    ): Promise<IGetDeparturesResponse> =>
        this.get<IGetDeparturesResponse>('getDepartures', {params});
}

export const browserLevelTravelProvider = new LevelTravelProvider();
