import ILevelTravelService from 'server/services/LevelTravelService/types/ILevelTravelService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserLevelTravelProvider} from './browserLevelTravelProvider';

export const levelTravel = {
    provider(container?: IDependencies): ILevelTravelService {
        return getProvider<'levelTravelService', ILevelTravelService>(
            browserLevelTravelProvider,
            'levelTravelService',
        )(container);
    },
};
