import IToursService from 'server/services/ToursService/types/IToursService';
import IGetToursWidgetInfoApiResponse from 'server/api/ToursApi/types/IGetToursWidgetInfoApiResponse';
import IBindToursApiRequestParams from 'server/api/ToursApi/types/IBindToursApiRequestParams';
import {TBindToursApiResponse} from 'server/api/ToursApi/types/TBindToursApiResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class ToursProvider extends BrowserHttpClient implements IToursService {
    constructor() {
        super({baseURL: '/api/tours/'});
    }

    getToursWidgetInfo = (): Promise<IGetToursWidgetInfoApiResponse> =>
        this.get<IGetToursWidgetInfoApiResponse>('getToursWidgetInfo');

    bindTour = (
        params: IBindToursApiRequestParams,
    ): Promise<TBindToursApiResponse> =>
        this.post<TBindToursApiResponse>('bindTour', undefined, {
            params,
        });
}

export const browserToursProvider = new ToursProvider();
