import {ETrainsPartner} from 'projects/trains/constants/trainPartners';

import {IActivePartnersParams} from 'server/services/TrainsService/types/IActivePartnersParams';
import {
    ITrainsSaveOfferServiceParams,
    ITrainsSaveOfferServiceResponse,
} from 'server/services/TrainsService/types/ITrainsSaveOfferService';
import {IRaspGetCountriesService} from 'server/services/RaspService/types/IRaspGetCountriesService';
import {ITrainsGetSuggestsService} from 'server/services/TrainsService/types/ITrainsGetSuggestsService';
import {ITrainsSaveDocumentsAndTravelerToNotebookServiceParams} from 'server/services/TrainsService/types/ITrainsSaveDocumentsAndTravelerToNotebookServiceParams';
import {ITrainsAddInsuranceServiceParams} from 'server/services/TrainsService/types/ITrainsAddInsuranceServiceParams';
import {ITrainsDetailsApiParams} from 'server/api/TrainsApi/types/ITrainsDetailsApiParams';
import {ITrainsDetailsInfoServiceResponse} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';
import {ITrainsLogBanditApiParams} from 'server/api/TrainsApi/types/ITrainsLogBanditApiParams';
import {ITrainsOrderDetails} from 'reducers/trains/order/types';
import {ITrainsService} from 'server/services/TrainsService/types/ITrainsService';
import ITrainsChangeRegistrationStatusParams from 'server/api/TrainsBookingApi/types/ITrainsChangeRegistrationStatusParams';
import ITrainsGetActualizedOrderServiceParams from 'server/services/TrainsService/types/ITrainsGetActualizedOrderServiceParams';
import ITrainsDownloadBlankApiParams from 'server/api/TrainsBookingApi/types/ITrainsDownloadBlankApiParams';
import {
    ITrainsTestContextTokenAnswer,
    ITrainsTestContextTokenParams,
} from 'server/api/TrainsBookingApi/types/ITrainsTestContextToken';
import {ITrainsGetFirmTrainService} from 'server/services/TrainsService/types/ITrainsGetFirmTrainService/ITrainsGetFirmTrainService';
import {ITrainsGetDirectionSearchService} from 'server/services/TrainsService/types/ITrainsGetDirectionSearchService/ITrainsGetDirectionSearchService';
import {ITrainsGetTariffsService} from 'server/services/TrainsService/types/ITrainsGetTariffsService/ITrainsGetTariffsService';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';
import {createAxiosRetryConfig} from 'utilities/api/createAxiosRetryConfig';

/**
 * Провайдер для выполнения http запросов на стороне браузера к контроллеру жд.
 */
class TrainsBrowserProvider
    extends BrowserHttpClient
    implements ITrainsService
{
    constructor() {
        super({baseURL: '/api/trains'});
    }

    getSuggests: ITrainsGetSuggestsService = params =>
        this.get('searchSuggest', {params});

    countries: IRaspGetCountriesService = () => this.get('countries');

    /**
     * Получение доступных партнеров для определения доступности продаж на стороне портала.
     */
    activePartners = (
        params: IActivePartnersParams,
    ): Promise<ETrainsPartner[]> => {
        return this.get('activePartners', {params});
    };

    getTariffs: ITrainsGetTariffsService = params => {
        return this.get('tariffs', {params});
    };

    getTrainDetails = (
        params: ITrainsDetailsApiParams,
    ): Promise<ITrainsDetailsInfoServiceResponse> => {
        return this.post('trainDetails', params);
    };

    addInsurance = (
        params: ITrainsAddInsuranceServiceParams,
    ): Promise<void> => {
        return this.post('addInsurance', params, {
            axiosRetry: createAxiosRetryConfig(),
        });
    };

    logBandit = (params: ITrainsLogBanditApiParams): Promise<void> => {
        return this.post('logBandit', params);
    };

    saveOffer = (
        params: ITrainsSaveOfferServiceParams,
    ): Promise<ITrainsSaveOfferServiceResponse> => {
        return this.post('saveOffer', params, {
            axiosRetry: createAxiosRetryConfig(),
        });
    };

    /**
     * @deprecated - использовать notebookService
     */
    saveDocumentsAndTravelerToNotebook = (
        params: ITrainsSaveDocumentsAndTravelerToNotebookServiceParams,
    ): Promise<void> => {
        return this.post('saveDocumentsAndTravelerToNotebook', params, {
            axiosRetry: createAxiosRetryConfig(),
        });
    };

    changeOrderRegistrationStatus = (
        params: ITrainsChangeRegistrationStatusParams,
    ): Promise<void> => {
        return this.post('changeOrderRegistrationStatus', params, {
            axiosRetry: createAxiosRetryConfig(),
        });
    };

    downloadBlank = (
        params: ITrainsDownloadBlankApiParams,
    ): Promise<NodeJS.ReadableStream> => {
        return this.get('downloadBlank', {params});
    };

    getActualizedTrainApiOrder = (
        params: ITrainsGetActualizedOrderServiceParams,
    ): Promise<ITrainsOrderDetails> => {
        return this.get('getActualizedTrainApiOrder', {
            params,
            axiosRetry: createAxiosRetryConfig(),
        });
    };

    getFirmTrain: ITrainsGetFirmTrainService = params =>
        this.get('getFirmTrain', {
            params,
            axiosRetry: createAxiosRetryConfig(),
        });

    getDirectionSearch: ITrainsGetDirectionSearchService = params =>
        this.get('getDirectionSearch', {
            params,
            axiosRetry: createAxiosRetryConfig(),
        });

    testContextToken(
        params: ITrainsTestContextTokenParams,
    ): Promise<ITrainsTestContextTokenAnswer> {
        return this.get('testContextToken', {
            params,
            axiosRetry: createAxiosRetryConfig(),
        });
    }
}

export const trainsBrowserProvider = new TrainsBrowserProvider();
