import {
    ITrainsSearchInfoResponse,
    ITrainsSearchRequestParams,
} from 'server/api/TrainsSearchApi/types/ITrainsSearch';
import {
    ITrainsCrossLinksRequestParams,
    ITrainsCrossLinksResponse,
} from 'server/api/TrainsSearchApi/types/ITrainsCrossLinks';
import {
    ITrainsPriceCalendarRequestParams,
    ITrainsPriceCalendarResponse,
} from 'server/api/TrainsSearchApi/types/ITrainsPriceCalendar';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {ITrainsSearchService} from 'server/services/TrainsSearchService/TrainsSearchService';

export class BrowserTrainsSearchProvider
    extends BrowserHttpClient
    implements ITrainsSearchService
{
    constructor() {
        super({baseURL: '/api/trains/'});
    }

    search = async (
        searchParams: ITrainsSearchRequestParams,
    ): Promise<ITrainsSearchInfoResponse> =>
        this.get<ITrainsSearchInfoResponse>('genericSearch', {
            params: searchParams,
        });

    getCrossLinks = async (
        params: ITrainsCrossLinksRequestParams,
    ): Promise<ITrainsCrossLinksResponse> =>
        this.get<ITrainsCrossLinksResponse>('getCrossLinks', {
            params,
        });

    priceCalendar = async (
        params: ITrainsPriceCalendarRequestParams,
    ): Promise<ITrainsPriceCalendarResponse> =>
        this.get<ITrainsPriceCalendarResponse>('priceCalendar', {
            params,
        });
}

export const browserTrainsSearchProvider = new BrowserTrainsSearchProvider();
