import {ITrainsSearchService} from 'server/services/TrainsSearchService/TrainsSearchService';
import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserTrainsSearchProvider} from './browserTrainsSearchProvider';

export const trainsSearchProvider = {
    provider(container?: IDependencies): ITrainsSearchService {
        return getProvider<'trainsSearchService', ITrainsSearchService>(
            browserTrainsSearchProvider,
            'trainsSearchService',
        )(container);
    },
};
