import ITripsService from 'server/services/TripsService/types/ITripsService';
import IGetActiveTripsApiResponse from 'server/api/TripsApi/types/IGetActiveTripsApiResponse';
import IGetTripsApiResponse from 'server/api/TripsApi/types/IGetTripsApiResponse';
import IGetMoreTripsApiRequest from 'server/api/TripsApi/types/IGetMoreTripsApiRequest';
import IGetMoreTripsApiResponse from 'server/api/TripsApi/types/IGetMoreTripsApiResponse';
import IGetTripResponse from 'server/api/TripsApi/types/IGetTripResponse';
import IGetTripRequestRequest from 'server/api/TripsApi/types/IGetTripRequestRequest';
import IGetTripsApiRequest from 'server/api/TripsApi/types/IGetTripsApiRequest';
import IGetTripAsyncBlocksRequest from 'server/api/TripsApi/types/IGetTripAsyncBlocksRequest';
import IGetTripAsyncBlocksResponse from 'server/api/TripsApi/types/IGetTripAsyncBlocksResponse';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

export class TripsProvider extends BrowserHttpClient implements ITripsService {
    constructor() {
        super({baseURL: '/api/trips/'});
    }

    getActiveTrips = (): Promise<IGetActiveTripsApiResponse> =>
        this.get<IGetActiveTripsApiResponse>('getActiveTrips');

    getTrips = (params: IGetTripsApiRequest): Promise<IGetTripsApiResponse> =>
        this.get<IGetTripsApiResponse>('getTrips', {params});

    getMoreTrips = (
        params: IGetMoreTripsApiRequest,
    ): Promise<IGetMoreTripsApiResponse> =>
        this.get<IGetMoreTripsApiResponse>('getMoreTrips', {params});

    getTrip = (params: IGetTripRequestRequest): Promise<IGetTripResponse> =>
        this.get<IGetTripResponse>('getTrip', {params});

    getTripAsyncBlock = (
        params: IGetTripAsyncBlocksRequest,
    ): Promise<IGetTripAsyncBlocksResponse> =>
        this.get<IGetTripAsyncBlocksResponse>('getTripAsyncBlock', {params});
}

export const browserTripsProvider = new TripsProvider();
