import ITripsService from 'server/services/TripsService/types/ITripsService';

import {IDependencies} from 'server/getContainerConfig';

import {getProvider} from 'serviceProvider/core';

import {browserTripsProvider} from './browserTripsProvider';

export const trips = {
    provider(container?: IDependencies): ITripsService {
        return getProvider<'tripsService', ITripsService>(
            browserTripsProvider,
            'tripsService',
        )(container);
    },
};
