import {IGetForecastByGeoIdResponse} from 'server/api/WeatherApi/types/IGetForecastByGeoIdResponse';
import {IGetForecastByGeoIdParams} from 'server/api/WeatherApi/types/IGetForecastByGeoIdParams';

import {BrowserHttpClient} from 'utilities/browserHttpClient/BrowserHttpClient';

import {IWeatherService} from 'server/services/WeatherService/WeatherService';

export class WeatherProvider
    extends BrowserHttpClient
    implements IWeatherService
{
    constructor() {
        super({baseURL: '/api/weather/'});
    }

    getWeatherForecastByGeoId = (
        params: IGetForecastByGeoIdParams,
    ): Promise<IGetForecastByGeoIdResponse> => {
        return this.get('getWeatherForecastByGeoId', {params});
    };
}

export const browserWeatherProvider = new WeatherProvider();
