import {IDependencies} from 'server/getContainerConfig';
import {IWeatherService} from 'server/services/WeatherService/WeatherService';

import {getProvider} from 'serviceProvider/core';
import {browserWeatherProvider} from 'serviceProvider/weather/weatherProvider/browserWeatherProvider';

export const weather = {
    provider(container?: IDependencies): IWeatherService {
        return getProvider<'weatherService', IWeatherService>(
            browserWeatherProvider,
            'weatherService',
        )(container);
    },
};
