import preval from 'preval.macro';

interface IColorsVars {
    light: Record<string, string>;
    dark: Record<string, string>;
}

// Load and parse on the server side
const colorsVars: IColorsVars = preval`
  const fs = require('fs');
  const path = require('path');
  const { extractVars } = require('string-extract-sass-vars');

  function getColorsVars(fileName) {
    const colorsPath = path.resolve(__dirname, '..', '..', '..', fileName);
    const colorsText = fs.readFileSync(colorsPath, 'utf8');

    return extractVars(colorsText);
  }

  module.exports = {
    light: getColorsVars('lightThemeColors.scss'),
    dark: getColorsVars('darkThemeColors.scss'),
  };
`;

export default colorsVars;
