export enum EApiEntry {
    TRAVEL = 'travel',
    AVIA_FRONT = 'aviaFront',
    AVIA = 'avia',
    AVIA_GATEWAY = 'aviaGateway',
    FLIGHT_STORAGE = 'flightStorage',
    TRAINS = 'trains',
    TRAVELLERS = 'travellers',
    RASP = 'rasp',
    RASP_CACHE = 'raspCache',
    RASP_SUGGESTS = 'raspSuggests',
    TRAINS_OFFER_STORAGE = 'trainsOfferStorage',
    PASSENGER_EXPERIENCE = 'passengerExperience',
    AVIA_TICKET_DAEMON = 'aviaTicketDaemon',
    AVIA_BACKEND = 'aviaBackend',
    AVIA_SUGGESTS = 'aviaSuggests',
    AVIA_PRICE_INDEX = 'aviaPriceIndex',
    TINY_URL = 'tinyUrl',
    BUSES_GEO = 'busesGeo',
    BUSES = 'buses',
    BUNKER = 'bunker',
    REVIEWS = 'reviews',
    IMAGE_GENERATOR = 'imageGenerator',
    TEMPLATOR = 'templator',
    LEVEL_TRAVEL = 'levelTravel',
    HOTELS_EXTRANET = 'hotelsExtranet',
}

export function isEApiEntry(value: string): value is EApiEntry {
    return Object.values(EApiEntry).some(item => item === value);
}
