import {ECalendarType} from 'components/Calendar/types';

export interface ICalendarPrice {
    currency: string;
    value: number;
    roughly: boolean;
    isLow?: boolean;
}

export type TCalendarPrices = Record<string, ICalendarPrice>;

export interface ICalendarPricesByType {
    [ECalendarType.StartDate]?: TCalendarPrices;
    [ECalendarType.EndDate]?: TCalendarPrices;
}
