import {TBookingPromoCampaigns} from 'server/api/AviaBookingApi/types/IBookingVariantsResponse';
import {IAviaOrderSegment} from 'types/avia/book/IAviaOrderSegment';
import {EAviaOrderError} from 'server/api/OrdersAPI/types/IAviaOrderResponse';

export interface IAviaOrder {
    id: string;
    prettyId: string;
    email: string;
    phone: string;
    airReservation: IAirOrderReservation;
    displayState: EAviaOrderDisplayState;
    errorCode?: EAviaOrderError;
    /** Показываем ли баннер Яндекс.Плюса (промокод плюса отправлен вам на e-mail) */
    promoCampaigns?: TBookingPromoCampaigns;
}

export enum EAviaOrderDisplayState {
    OS_IN_PROGRESS = 'OS_IN_PROGRESS',
    OS_AWAITS_PAYMENT = 'OS_AWAITS_PAYMENT',
    OS_CANCELLED = 'OS_CANCELLED',
    OS_FULFILLED = 'OS_FULFILLED',
    OS_REFUNDED = 'OS_REFUNDED',
}

export interface IAirOrderReservation {
    pnr: string;
    segments: IAviaOrderSegment[];
}
