import {
    ETextBlocksType,
    ISectionTextBlock,
} from 'types/common/seoPages/ITextBlocks';
import {ISeoInfo} from 'types/hotels/common/ISeoInfo';
import {ILinksListBlock} from 'types/common/seoPages/ILinksListBlock';

import IPrice from 'utilities/currency/PriceInterface';
import {IFAQSchemaMarkupItem} from 'components/SchemaMarkup/utilities/getFAQSchemaMarkup';

export interface ILandingSectionTextBlock extends ISectionTextBlock {
    data: {
        text?: string;
        title?: string;
        navigationTitle?: string;
    };
}

export enum ELandingBlockType {
    breadCrumbsBlock = 'IBreadCrumbsBlock',
    searchFormBlock = 'ISearchFormBlock',
    dynamicsBlock = 'IDynamicsBlock',
    aviaCompaniesBlock = 'IAviaCompaniesBlock',
    closestCitiesBlock = 'IClosestCitiesBlock',
    returnTicketBlock = 'IReturnTicketBlock',
    cityDirectionsBlock = 'ICityDirectionsBlock',
}

/**
 * Ссылка ведущая на страницу результатов поиска авиа
 */
export interface ISearchAviaLinkBlock {
    type: ETextBlocksType.searchAviaLinkBlock;
    data: {
        /**
         * Текст ссылки
         */
        text: string;
        /**
         * Количество мест для взрослых
         */
        adults: number;
        /**
         * Количество мест для детей
         */
        children?: number;
        /**
         * Количество мест для младенцев
         */
        infants?: number;
        /**
         * Id города вылета
         */
        fromId: string;
        /**
         * Id города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
        /**
         * Дата обратного вылета
         */
        returnDate?: string;
    };
}

/**
 * Ссылка на страницу направления (другую сео-страницу)
 */
export interface ILandingLinkBlock {
    type: ETextBlocksType.routeLinkBlock;
    data: {
        /**
         * Текст ссылки
         */
        text: string;
        /**
         * Slug города вылета
         */
        fromSlug: string;
        /**
         * Slug города прилета
         */
        toSlug: string;
    };
}

/**
 * Блок для отрисовки хлебных крошек
 */

export interface IBreadCrumbsBlock {
    type: ELandingBlockType.breadCrumbsBlock;
    data: {
        items: IBreadCrumbItem[];
    };
}

export interface IBreadCrumbItem {
    title: string;
    link?: string;
}

/**
 * Блок для отрисковки формы поиска
 */
export interface ISearchFormBlock {
    type: ELandingBlockType.searchFormBlock;
}

/**
 * Блок динамиики (заголовок и описание)
 */
export interface IDynamicsBlock {
    type: ELandingBlockType.dynamicsBlock;
}

/**
 * Цена на перелет авиакомпанией
 */
export interface IAviaCompanyPriceBlock {
    /**
     * ID авиакомпании
     */
    id: string;
    /**
     * Название авиакомпании
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price: IPrice;
    /**
     * Дата перелета
     */
    when: string;
    /**
     * Признак перелёта с пересадками
     */
    withTransfers: boolean;
    /**
     * Дата перелета обратно
     */
    returnDate?: string;
}

/**
 * Блок со стоимостью перелета по авиакомпаниям
 */
export interface IAviaCompaniesBlock {
    type: ELandingBlockType.aviaCompaniesBlock;
    data: ILinksListBlock<IAviaCompanyPriceBlock>;
}

/**
 * Цена на перелет в город
 */
export interface ICityPriceBlock {
    /**
     * Slug городв
     */
    toSlug: string;
    /**
     * Название города
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price: IPrice;
}

/**
 * Блок со стоимостью перелета в соседние города
 */
export interface IClosestCitiesBlock {
    type: ELandingBlockType.closestCitiesBlock;
    data: ILinksListBlock<ICityPriceBlock>;
}

/**
 * Цена на перелет по направлению
 */
export interface ILandingRoutePrice {
    /**
     * Slug города вылета
     */
    fromSlug: string;
    /**
     * Slug городв прибытия
     */
    toSlug: string;
    /**
     * Название
     */
    name: string;
    /**
     * Стоимость перелета
     */
    price: IPrice;
}

export interface IReturnTicketBlock {
    type: ELandingBlockType.returnTicketBlock;
    data: ILinksListBlock<ILandingRoutePrice>;
}

export interface ICityDirectionItem {
    /**
     * Slug города вылета
     */
    fromSlug: string;
    /**
     * Название
     */
    name: string;

    /**
     * Цена
     */
    price: IPrice;
}

export interface ICityDirectionsBlock {
    type: ELandingBlockType.cityDirectionsBlock;
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок для быстрых ссылок (если не передан - то в навигации не участвует)
         */
        navigationTitle?: string;
        /**
         * Описание блока
         */
        text?: string;
        /**
         * Список направлений с ценами
         */
        items: ICityDirectionItem[];
    };
}

export interface IAviaSeoInfoSchemaOrg {
    faqItems: IFAQSchemaMarkupItem[];
}

export interface IAviaLandingSeoInfo extends ISeoInfo<IAviaSeoInfoSchemaOrg> {}
