import {IDestinationInformation} from 'server/api/AviaCountryRestrictionsApi/types/TAviaCountryRestrictionsApiResponse';
import {IImage} from 'types/common/IImage';
import ILinguistics from 'types/common/ILinguistics';
import {IExpiringPrice} from 'types/common/price/IExpiredPrice';
import {TSettlementKey} from 'types/PointKey';

/** Описание города на странице поиска в страну и поиска "куда угодно" */
export interface ISettlementInfo {
    /** @example 'c213' */
    key: TSettlementKey;
    /** Название города */
    title: ILinguistics;
    /** Массив массивов изображений. То есть images[0] содержит массив с разными размерами первого изображения */
    images: IImage[][];

    /** Цена, полученная от бэкенда при запросе страницы (из priceIndex) */
    price: IExpiringPrice | null;
}

/** Описание города на странице поиска "куда угодно" */
export interface IAnywhereSettlementInfo {
    /** @example 'c213' */
    key: TSettlementKey;
    /** Название города */
    title: ILinguistics;
    /** Массив массивов изображений. То есть images[0] содержит массив с разными размерами первого изображения */
    images: IImage[][];

    /** Цена, полученная от бэкенда при запросе страницы (из priceIndex) */
    price: IExpiringPrice | null;

    /** Гео данные города: страна и координаты */
    geo_data: {
        countryId: number;
        latitude: number;
        longitude: number;
        popularity: number;
    };

    /** Ограничения для страны */
    country_restrictions: IDestinationInformation;
}
