import {
    IAviaLandingSeoInfo,
    IAviaCompaniesBlock,
    IBreadCrumbsBlock,
    IClosestCitiesBlock,
    IDynamicsBlock,
    ICityDirectionsBlock,
    ISearchFormBlock,
    ILandingSectionTextBlock,
} from 'types/avia/landing/IAviaLanding';

/**
 * Блок для отрисковки формы поиска
 */
export interface IFlightsToSearchFormBlock extends ISearchFormBlock {
    data: {
        /**
         * Ссылка на картинку для формы
         */
        imageUrl: string;
        /**
         * Заголовок над формой
         */
        title: string;
        /**
         * Параметры для отрисовки формы
         */
        searchFormParams: {
            /**
             * ID города прибытия для предзаполнения саджеста
             */
            toId: string;
            /**
             * Открывать ли календарик по дефолту
             */
            isCalendarOpen: boolean;
        };
    };
}

/**
 * Блок динамиики (заголовок и описание)
 */
export interface IFlightsToDynamicsBlock extends IDynamicsBlock {
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок блока
         */
        navigationTitle?: string;
        /**
         * Описание блока
         */
        description?: string;
        /**
         * ID города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
    };
}

/**
 * Верхнеуровневые блоки
 */
export type TAviaFlightsToBlock =
    | IBreadCrumbsBlock
    | IFlightsToSearchFormBlock
    | IFlightsToDynamicsBlock
    | ILandingSectionTextBlock
    | IAviaCompaniesBlock
    | IClosestCitiesBlock
    | ICityDirectionsBlock;

export interface IAviaFlightsToResponse {
    /**
     * Seo info
     */
    seoInfo: IAviaLandingSeoInfo;

    /**
     * Блоки
     */
    blocks: TAviaFlightsToBlock[];
}
