import {
    IAviaLandingSeoInfo,
    IAviaCompaniesBlock,
    IBreadCrumbsBlock,
    IClosestCitiesBlock,
    IDynamicsBlock,
    IReturnTicketBlock,
    ISearchFormBlock,
    ILandingSectionTextBlock,
} from 'types/avia/landing/IAviaLanding';
import {ITransportRoutesBlock} from 'types/common/seoPages/ITransportRoutesBlock';
import {ICrossSaleHotelsBlock} from 'types/common/seoPages/ICrossSaleHotelsBlock';

/**
 * Блок для отрисковки формы поиска
 */
export interface IRouteSearchFormBlock extends ISearchFormBlock {
    data: {
        /**
         * Ссылка на картинку для формы
         */
        imageUrl: string;
        /**
         * Заголовок над формой
         */
        title: string;
        /**
         * Параметры для отрисовки формы
         */
        searchFormParams: {
            /**
             * ID города отправления для предзаполнения саджеста
             */
            fromId: string;
            /**
             * ID города прибытия для предзаполнения саджеста
             */
            toId: string;
            /**
             * Открывать ли календарик по дефолту
             */
            isCalendarOpen: boolean;
        };
    };
}

/**
 * Блок динамиики (заголовок и описание)
 */
export interface IRouteDynamicsBlock extends IDynamicsBlock {
    data: {
        /**
         * Заголовок блока
         */
        title: string;
        /**
         * Заголовок блока
         */
        navigationTitle?: string;
        /**
         * Описание блока
         */
        description?: string;
        /**
         * ID города вылета
         */
        fromId: string;
        /**
         * ID города прилета
         */
        toId: string;
        /**
         * Дата вылета
         */
        when: string;
    };
}

/**
 * Верхнеуровневые блоки
 */
export type TAviaRouteBlock =
    | IBreadCrumbsBlock
    | IRouteSearchFormBlock
    | IRouteDynamicsBlock
    | ILandingSectionTextBlock
    | IAviaCompaniesBlock
    | IClosestCitiesBlock
    | ITransportRoutesBlock
    | ICrossSaleHotelsBlock
    | IReturnTicketBlock;

export interface IAviaRouteResponse {
    /**
     * Seo info
     */
    seoInfo: IAviaLandingSeoInfo;

    /**
     * Блоки
     */
    blocks: TAviaRouteBlock[];
}
