import {IFormDocument} from 'components/BookingPassengerForm/types/IDocument';
import {EBusesTicketType} from 'types/buses/booking/IBusesBookParams';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';

export enum EBusesBookGroup {
    PASSENGERS = 'passengers',
    CONTACTS = 'contacts',
}

export enum EBusesPassengerFormFiled {
    TARIFF = 'tariff',
    BAGGAGE_COUNT = 'baggageCount',
}

export type TBusesPassengerTicketTariff =
    | EBusesTicketType.FULL
    | EBusesTicketType.CHILD;

export interface IBusesPassenger extends IFormDocument {
    [EBusesPassengerFormFiled.TARIFF]?: TBusesPassengerTicketTariff;
    [EBusesPassengerFormFiled.BAGGAGE_COUNT]?: string;
}

export interface IBusesBookFormValues {
    [EBusesBookGroup.PASSENGERS]?: IBusesPassenger[];
    [EBusesBookGroup.CONTACTS]?: TBookingContacts;
}
