import {EGender} from 'types/common/document/EGender';
import {ICountry} from 'types/common/ICountry';

import IPrice from 'utilities/currency/PriceInterface';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export enum EBusesTicketType {
    FULL = 'FULL',
    CHILD = 'CHILD',
    BAGGAGE = 'BAGGAGE',
}

export interface IBusesFare {
    total: IPrice;
    ticket: IPrice;
    supplierFee: IPrice;
    yandexFee: IPrice;
}

export interface IBusesTicketType {
    type: EBusesTicketType;
    fare: IBusesFare;
}

export enum EBusesPlaceType {
    DRIVER = 'DRIVER',
    SEAT = 'SEAT',
    PASSAGE = 'PASSAGE',
}

export enum EBusesPlaceStatus {
    FREE = 'FREE',
    OCCUPIED = 'OCCUPIED',
}

export interface IBusesPlace {
    id: string;
    x: number;
    y: number;
    type: EBusesPlaceType;
    status: EBusesPlaceStatus;
}

export interface IBusesBookParams {
    documentTypes: EDocumentType[];
    ticketTypes: IBusesTicketType[];
    genders: EGender[];
    seats: string[];
    placesMap: IBusesPlace[];
    citizenships: ICountry[];
}
