import {ICoordinate} from 'server/utilities/earthGeometry';

export enum EPointType {
    SETTLEMENT = 'SETTLEMENT',
    STATION = 'STATION',
}

export interface IBusesPoint {
    supplierDescription: string;
    type?: EPointType;
    title?: string;
    timezone?: string;
    address?: string;
    coordinates?: ICoordinate;
}

export enum ERegisterType {
    COMPANY = 'COMPANY',
    ENTREPRENEUR = 'ENTREPRENEUR',
}

export interface ILegalEntity {
    registerType: ERegisterType;
    registerNumber: string;
    name?: string;
    legalName?: string;
    legalAddress?: string;
    actualAddress?: string;
    taxationNumber?: string;
    timetable?: string;
}

export enum EBusBenefit {
    COFFEE = 'COFFEE',
    CHARGER = 'CHARGER',
    PRESS = 'PRESS',
    TV = 'TV',
    WI_FI = 'WI_FI',
    NO_TICKET_REQUIRED = 'NO_TICKET_REQUIRED',
    WC = 'WC',
    CONDITIONER = 'CONDITIONER',
    COMMON_AUDIO = 'COMMON_AUDIO',
}

export interface IBusesRide {
    id: string;
    departure: string;
    arrival?: string;
    duration?: number;
    titlePointFrom: IBusesPoint;
    titlePointTo: IBusesPoint;
    pointFrom: IBusesPoint;
    pointTo: IBusesPoint;
    busDescription?: string;
    routeName?: string;
    routeNumber?: string;
    supplier: ILegalEntity;
    carrier?: ILegalEntity;
    freeSeats?: number;
    ticketLimit?: number;
    benefits: EBusBenefit[];
    refundConditions?: string;
}
