import {Overwrite} from 'utility-types';

import {
    IFilledContextPoint,
    IRaspParseContextApiResponse,
    TContextPointType,
} from 'server/api/RaspApi/types/IRaspParseContextApiResponse';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

export interface IBusesApiContext extends IRaspParseContextApiResponse {}

export interface IBusesContext extends IBusesApiContext {
    when: string | null;
    originWhen: string | WHEN_SPECIAL_VALUE | null;
}

export interface IBusesFilledContext
    extends Overwrite<
        IBusesContext,
        {
            from: Omit<IFilledContextPoint, 'titleWithType' | 'preposition'>;
            to: Omit<IFilledContextPoint, 'titleWithType' | 'preposition'>;
        }
    > {}

export function isFilledContextPoint(
    contextPoint: TContextPointType,
): contextPoint is IFilledContextPoint {
    return Boolean(contextPoint && contextPoint.timezone);
}

export function isFilledContext(
    context: IBusesContext | null,
): context is IBusesFilledContext {
    return Boolean(
        context &&
            isFilledContextPoint(context.from) &&
            isFilledContextPoint(context.to),
    );
}
