import {Overwrite} from 'utility-types';

import {IBusesApiSuggest} from 'server/api/BusesGeoApi/types/IBusesGetSuggestsApiResponse';

export enum EBusesSuggestType {
    SETTLEMENT = 'settlement',
    STATION = 'station',
}

export interface IBusesSuggest
    extends Overwrite<
        IBusesApiSuggest,
        {
            objId: string;
        }
    > {
    isUniqueTitle: boolean;

    /**
     * Хак для ts, чтобы IBusesSuggest расширял IBaseSuggestItem
     * В будущем можно убрать, если обобщим хотя бы часть свойств саджестов всех вертикалей
     */
    isPreviousSearch?: boolean;
}
