import {ESearchErrorTypes} from 'projects/trains/lib/search/constants';

import ILinguistics from 'types/common/ILinguistics';

interface IContextPointCountry {
    code: string;
    title: string;
}

/**
 * Полная информация о пункте отправления/прибытия.
 */
interface IContextPoint {
    country: IContextPointCountry;
    key: string;
    region: {title: string};
    settlement: {title: string};
    slug: string;
    timezone: string;
    title: Pick<
        ILinguistics,
        'accusativeCase' | 'genitiveCase' | 'nominativeCase' | 'locativeCase'
    >;
}

export interface IBusesContext {
    when?: string;

    /** Информация о пункте отправления. */
    from: IContextPoint;

    /** Информация о пункте прибытия. */
    to: IContextPoint;

    /**
     * Дистанция между пунктами в км.
     * Не приходит для поиска внутри города, например moscow--moscow-yaroslavskaya
     */
    distance?: number;

    errors: ESearchErrorTypes[];
}
