import {TLocalDateTimeType} from 'types/common/date/IDate';
import {ICoordinates} from 'types/common/ICoordinates';

import IPrice from 'utilities/currency/PriceInterface';

interface IBusesApiPoint {
    /**
     * @example "Воронеж, трасса М4"
     * @example "авт.ост. Воронеж, трасса М4, г. Воронеж, Воронежская область, Россия
     */
    title: string;
    /**
     * Полное именование станции - отображается в модале с детальной информацией о станции
     * Не приходит когда нет информации о точке с ее координатами (тогда мы не показываем модал с картой)
     * @example "авт.вкз. Великий Новгород, г. Великий Новгород, Новгородская область, Россия"
     */
    fullTitle?: string;
    /** @example "Europe/Moscow" */
    timezone: string;
    coordinates?: ICoordinates;
}

export interface IBusesSeoSegment {
    id: string;
    carrierCode: string;
    carrierName?: string;
    arrivalTime?: TLocalDateTimeType;
    departureTime: TLocalDateTimeType;
    duration?: number;
    freeSeats: number;
    price: IPrice;
    from: IBusesApiPoint;
    to: IBusesApiPoint;
}
