import {
    EBusesSortDirection,
    EBusesSortType,
} from 'types/buses/search/EBusesSortType';
import {ETimeOfDay} from 'utilities/dateUtils/types';
import {EBusesSearchBookingInfoStatus} from 'reducers/buses/types/search/IBusesSearchBookingInfoStore';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

export interface IBusesSearchQuery {
    date?: string | WHEN_SPECIAL_VALUE;
    lastSearchTimeMarker?: string;
    sortBy?: EBusesSortType;
    sortDirection?: EBusesSortDirection;
    price?: string[];
    departureTime?: ETimeOfDay | ETimeOfDay[];
    arrivalTime?: ETimeOfDay | ETimeOfDay[];
    departureStation?: string | string[];
    arrivalStation?: string | string[];
    testBookingInfoStatus?: EBusesSearchBookingInfoStatus;
}
