import {Overwrite} from 'utility-types';

import {TLocalDateTimeType} from 'types/common/date/IDate';
import {IBusesApiSegment} from 'server/api/BusesApi/types/IBusesGetSegmentsApiResponse';
import {ICoordinates} from 'server/api/GenericOrderApi/types/common/service/IHotelServiceInfo/IHotelOfferInfo/IPartnerHotelInfo/ICoordinates';

export interface IBusesPatchedApiPoint {
    id?: number;
    timezone: string;
    title: string;
}

export interface IBusesGeoPointWithCoordinates {
    id?: number;
    timezone: string;
    title: string;
    code: string;
    description: string;
    coordinates: ICoordinates;
}

export type TBusesPoint = IBusesGeoPointWithCoordinates | IBusesPatchedApiPoint;

export interface IBusesSegment
    extends Overwrite<
        IBusesApiSegment,
        {
            arrivalTime: TLocalDateTimeType | null;
            departureTime: TLocalDateTimeType;
            duration: number | null;
            from: TBusesPoint;
            to: TBusesPoint;
        }
    > {}
