import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {ETimeOfDay} from 'utilities/dateUtils/types';

export interface IBusesFilters {
    [EBusesFilter.PRICE]: {
        value: [number, number] | null;
        range: [number, number] | null;
        hiddenByFilter: Set<string>;
    };
    [EBusesFilter.DEPARTURE_TIME]: {
        value: ETimeOfDay[];
        options: ETimeOfDay[];
        hiddenByFilter: Set<string>;
        availableOptions: ETimeOfDay[];
    };
    [EBusesFilter.ARRIVAL_TIME]: {
        value: ETimeOfDay[];
        options: ETimeOfDay[];
        hiddenByFilter: Set<string>;
        availableOptions: ETimeOfDay[];
    };
    [EBusesFilter.DEPARTURE_STATION]: {
        value: string[];
        options: string[];
        hiddenByFilter: Set<string>;
        availableOptions: string[];
    };
    [EBusesFilter.ARRIVAL_STATION]: {
        value: string[];
        options: string[];
        hiddenByFilter: Set<string>;
        availableOptions: string[];
    };
}
