import {EBusesFilter} from 'types/buses/search/filters/EBusesFilter';
import {ETimeOfDay} from 'utilities/dateUtils/types';

export interface IBusesPriceFilterTypeAndValue {
    type: EBusesFilter.PRICE;
    value: [number, number] | null;
}

export interface IBusesStationFilterTypeAndValue {
    type: EBusesFilter.DEPARTURE_STATION | EBusesFilter.ARRIVAL_STATION;
    value: string;
}

export interface IBusesTimeOfDayFilterTypeAndValue {
    type: EBusesFilter.DEPARTURE_TIME | EBusesFilter.ARRIVAL_TIME;
    value: ETimeOfDay;
}

export type TBusesFilterTypeAndValue =
    | IBusesPriceFilterTypeAndValue
    | IBusesStationFilterTypeAndValue
    | IBusesTimeOfDayFilterTypeAndValue;

export type TBusesFilterTypeAndValues =
    | {type: EBusesFilter.PRICE; values: [number, number] | null}
    | {
          type: EBusesFilter.DEPARTURE_STATION | EBusesFilter.ARRIVAL_STATION;
          values: string[];
      }
    | {
          type: EBusesFilter.DEPARTURE_TIME | EBusesFilter.ARRIVAL_TIME;
          values: ETimeOfDay[];
      };
