export enum EDirection {
    FORWARD = 'FORWARD',
    BACKWARD = 'BACKWARD',
}

export const DIRECTIONS = [EDirection.FORWARD, EDirection.BACKWARD];

export const DIRECTION_SHORT_NAMES: Record<EDirection, string> = {
    [EDirection.FORWARD]: 'f',
    [EDirection.BACKWARD]: 'b',
};

export const DIRECTIONS_MAP_BY_SHORT_NAME: Record<string, EDirection> = {
    f: EDirection.FORWARD,
    b: EDirection.BACKWARD,
};

export function isEDirection(candidate: unknown): candidate is EDirection {
    return DIRECTIONS.some(direction => candidate === direction);
}
