import {ECalendarType} from 'components/Calendar/types';

export interface ICalendarPricesByType {
    [ECalendarType.StartDate]?: TCalendarPrices;
    [ECalendarType.EndDate]?: TCalendarPrices;
}

export type TCalendarPrices = Record<
    string,
    ICalendarPrice | ICalendarEmptyPrice
>;

export interface ICalendarPrice {
    currency: string;
    value: number;
    roughly: boolean;
    isLow?: boolean;
}

export interface ICalendarEmptyPrice {
    emptyPriceReason?: ECalendarEmptyPriceReason;
}

export enum ECalendarEmptyPriceReason {
    SOLD_OUT = 'SOLD_OUT',
    NO_DIRECT_TRAINS = 'NO_DIRECT_TRAINS',
    NO_OFFERS = 'NO_OFFERS',
    OTHER = 'OTHER',
}
