export interface IBlackboxNotAuthUserInfo {
    isYandexNetwork?: boolean;
}

export interface IBlackboxAuthUserInfo extends IBlackboxNotAuthUserInfo {
    users: {
        uid: string;
        displayName: string;
        avatar: {
            default: string;
        };
    }[];
    isAuth: boolean;
    uid: string;
    contacts: {
        phones: {
            phoneNumber: string;
            formattedPhoneNumber: string;
        };
        email: string;
    };
    avatar: {
        default: string;
        empty: boolean;
    };
    displayName: string;
    lang: string;
    // TODO: удалить после раскатки plusInfo
    havePlus: boolean;
    isStaff: boolean;
    isBetaTest: boolean;
    login: null | string;
    yandexLogin: string;
    isYandexNetwork: boolean;
}

export interface IUserPlusInfo {
    hasPlus: boolean;
    points?: number;
}

export type TBlackboxUserInfo =
    | IBlackboxAuthUserInfo
    | IBlackboxNotAuthUserInfo
    | undefined;
