import {FieldState} from 'final-form';

import {EFormKey} from 'constants/form/EFormKey';

import {TDependentValidations, TValidations} from './validation';

export interface IFormValidationInfo {
    /** Идентификатор формы */
    id: EFormKey;
    /**
     * Настройка, которая говорит о том, что структура правил строго
     * соотвествует структуре формы (группы, поля)
     *
     * Отключает гибкость валидации, для несгруппированных значений форм
     * Пример: src/utilities/validation/form/__tests__/baseValidation.test.ts
     */
    isStrictStructure?: boolean;

    fieldGroups: IFieldGroup[];
}

export type TFieldGroupId = string;

/**
 * @note - Контакная информация.
 * - Документ в ЗКП.
 * - Документ на форме бронирования.
 * - Тариф Авиа.
 * - Параметры поиска Авиабилетов.
 * - ...
 */
export interface IFieldGroup {
    id: TFieldGroupId;
    fields: TField[];
}

/** Тип, фиксирующий хотя бы одну из валидаций, как обязательную */
export type TFieldValidation =
    | {
          validation: IFieldValidation;
          dependentValidations?: TDependentValidations;
      }
    | {
          validation?: IFieldValidation;
          dependentValidations: TDependentValidations;
      };

export type TField = TFieldValidation & {
    name: string;
};

export interface IFieldValidation<
    T extends TValidations = TValidations,
    Y extends TValidations = T,
> {
    blur?: T;
    submit?: Y;
}

export interface IFormValues {
    [key: string]: any;
}

export interface IFieldError {
    blurError?: string;
    submitError?: string;
}

/**
 * Описывает функцию-валидатор поля формы
 */
export type TValidator<TFieldValue, TAllValues extends object> = (
    value: TFieldValue | undefined,
    allValues: TAllValues,
    meta?: FieldState<TFieldValue>,
) => undefined | string | IFieldError;
