import ICustomerUser from 'server/api/HotelsBookAPI/types/ICustomerUser';
import {
    IBookDeferredPaymentSchedule,
    IBookOrderOfferInfo,
} from 'server/api/HotelsBookAPI/types/IBookOffer';
import {IAppliedPromoCampaigns} from 'types/hotels/offer/IHotelOffer';

import IPrice from 'utilities/currency/PriceInterface';

import {IBookUserSelect} from './ICreateOrder';
import {IPromoCampaigns} from './IPromoCampaigns';

export enum EPromoCodesApplicationType {
    SUCCESS = 'SUCCESS',
    NOT_FOUND = 'NOT_FOUND',
    NOT_APPLICABLE = 'NOT_APPLICABLE',
    ALREADY_APPLIED = 'ALREADY_APPLIED',
    EXPIRED = 'EXPIRED',
}

export interface IPromoCodeApplicationResult {
    code: string;
    type: EPromoCodesApplicationType;
    discountAmount?: IPrice;
}

export interface IAppliedPromoCodesInfo {
    codeApplicationResults: IPromoCodeApplicationResult[];
    originalAmount: IPrice;
    discountedAmount: IPrice;
    discountAmount: IPrice;
    discountPlusPoints: number;
    promoCampaigns: IPromoCampaigns;
    deferredPaymentSchedule?: IBookDeferredPaymentSchedule;
}

/* Request */

export interface IApplyPromoCodesRequest extends ICustomerUser {
    bookUserSelect: IBookUserSelect;
    offerOrderInfo: IBookOrderOfferInfo;
    promoCodes: string[];
    appliedPromoCampaigns?: IAppliedPromoCampaigns;
}
