import {EFieldName} from 'components/BookingPassengerForm/constants/fieldNames';

import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {TBookingContacts} from 'components/BookingContactsForm/BookingContactsForm';
import {IFormDocument} from 'components/BookingPassengerForm/BookingPassengerForm';
import {EBookPriceInfoFieldName} from 'projects/hotels/components/BookPriceInfo/BookPriceInfo';

export interface IBookContacts extends TBookingContacts {
    /**
     * Вспомогательный ключ для валидаций. Не дает finalForm очистить пустой объект.
     * Нужен для сохранения структуры полей
     */
    validationKey: 'contacts';
}

export enum EBookGuestFieldName {
    INDEX = 'index',
}

export interface IBookGuest
    extends Pick<IFormDocument, EFieldName.firstName | EFieldName.lastName> {
    [EBookGuestFieldName.INDEX]?: number;
}

export interface IStorageBookGuest extends IBookGuest {
    ageGroup: 'adult' | 'children';
}

export interface IBookPriceInfo {
    [EBookPriceInfoFieldName.PLUS_MODE]: EYandexPlusApplicationMode;
    /**
     * Никак не используется = оторвано на бэкенде,
     * оставлено на случай включения без договоренности с фронтом,
     * т.к. API подразумевает такую возможность
     */
    [EBookPriceInfoFieldName.BEDS_GROUP_ID]: string;
    [EBookPriceInfoFieldName.USE_DEFERRED_PAYMENTS]: boolean;
}

export enum EBookWhiteLabelFieldName {
    CUSTOMER_NUMBER = 'customerNumber',
}

export interface IBookWhiteLabel {
    [EBookWhiteLabelFieldName.CUSTOMER_NUMBER]: string;
}

export enum EFormGroup {
    ADULT = 'adult',
    CHILDREN = 'children',
    CONTACTS = 'contacts',
    PRICE_INFO = 'priceInfo',
    WHITE_LABEL = 'whiteLabel',
}

export interface IBookChildGuest extends IBookGuest {
    age: number;
}

export interface IBookFormValues {
    [EFormGroup.ADULT]?: IBookGuest[];
    [EFormGroup.CHILDREN]?: IBookChildGuest[];
    [EFormGroup.CONTACTS]?: IBookContacts;
    [EFormGroup.PRICE_INFO]?: IBookPriceInfo;
    [EFormGroup.WHITE_LABEL]?: IBookWhiteLabel;
}
