/* eslint-disable camelcase */
import {NavigationTokenType} from 'types/hotels/search/INavigationTokens';
import {HotelSlugType, PermalinkType} from 'types/hotels/hotel/IHotel';
import {GeoIdType} from 'types/hotels/hotel/IGeoRegion';
import {SearchPageLayoutView} from 'types/hotels/search/ISearchLayout';
import {IMetaQueryParams, IUtmQueryParams} from 'types/common/IQueryParams';
import {TSortId} from 'types/hotels/search/ISortInfo';
import {EPortalSeedReferer} from 'types/hotels/common/IAttribution';

/* Base */
export interface IBaseSearchQueryParams {
    adults?: number;
    childrenAges?: string;
    checkinDate?: string;
    checkoutDate?: string;
}

export interface ISearchDebugQueryParams {
    debugUseProdOffers?: boolean;
}

export interface ISearchPollingParams {
    searchPagePollingId?: string;
}

export interface IAttributionQueryParams
    extends ISearchDebugQueryParams,
        IUtmQueryParams,
        IMetaQueryParams {}

/* SearchPage */
export interface ISearchPageQueryParams
    extends IBaseSearchQueryParams,
        ISearchPageQueryFilterParams,
        ISearchPageNavigationQueryParams,
        ISearchPageQueryMapParams,
        IAttributionQueryParams,
        ISearchPageGeoQueryParams,
        ISearchPageGeolocationQueryParams,
        ISearchPageTimeMarkerParams,
        ISearchPageLayoutQueryParams,
        ISearchPageSortQueryParams,
        ISearchPageTopHotelQueryParams {}

export interface ISearchPageGeoQueryParams {
    geoId?: GeoIdType;
}

export interface ISearchPageGeolocationQueryParams {
    sortOrigin?: string;
}

export interface ISearchPageTimeMarkerParams {
    lastSearchTimeMarker?: number;
}

export interface ISearchPageNavigationQueryParams {
    navigationToken?: NavigationTokenType;
}

export interface ISearchPageQueryFilterParams {
    filterAtoms?: string;
    searchText?: string;
    minPrice?: number;
    maxPrice?: number;
    onlyCurrentGeoId?: number;
}

export interface ISearchPageQueryMapParams {
    bbox?: string;
}

export interface ISearchPageLayoutQueryParams {
    serpView?: SearchPageLayoutView;
}

export interface ISearchPageSortQueryParams {
    selectedSortId?: TSortId;
}

export interface ISearchPageTopHotelQueryParams {
    topHotelSlug?: HotelSlugType;
}

export interface ISearchPagePollingParams extends ISearchPollingParams {}

/* HotelPage */
export interface IHotelPageAttributionQueryParams {
    label?: string;
    seed?: EPortalSeedReferer;
}

export interface IHotelPageTokenQueryParams {
    token?: string;
}

export interface IHotelPageOfferQueryParams
    extends IHotelPageAttributionQueryParams,
        IHotelPageTokenQueryParams {}

export interface IViewModePageQueryParams {
    isHeadless?: boolean;
}

export interface IHotelPageQueryParams
    extends IBaseSearchQueryParams,
        IAttributionQueryParams,
        IHotelPageOfferQueryParams,
        IViewModePageQueryParams {
    hotelPermalink?: PermalinkType;
}
