import {IHotelWithMinPrice} from 'types/hotels/hotel/IHotelWithMinPrice';
import {TSortId} from 'types/hotels/search/ISortInfo';
import {IFilterParams, IFullFilters} from 'types/hotels/search/IFiltersInfo';
import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {GeoIdType, IGeoRegion} from 'types/hotels/hotel/IGeoRegion';
import {
    ETextBlocksType,
    ISectionTextBlock,
} from 'types/common/seoPages/ITextBlocks';
import {IBreadcrumbs} from 'server/api/HotelSearchAPI/types/IHotelBreadcrumbs';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';
import {ICrossSaleHotelsBlock} from 'types/common/seoPages/ICrossSaleHotelsBlock';

import {IGeoRegionSeoInfo} from './ISeoInfo';

/* SearchForm Block */
export interface ISearchFormBlock {
    type: EGeoRegionBlockType.SEARCH_FORM_BLOCK;
    data: {
        imageUrl: string;
        title: string;
        searchFormParams: {
            isCalendarOpen: boolean;
            regionSlug: TGeoRegionSlug;
        };
        filterParams?: IFilterParams;
    };
}

/* Hotels Block */
export interface IHotelsBlock {
    type: EGeoRegionBlockType.HOTELS_BLOCK;
    data: {
        title: string;
        hotels: IHotelWithMinPrice[];
        searchButtonText: string;
        searchParams: ISearchPageIdentifyParams;
        /**
         * Информация о регионе отеля (склонения, slug)
         */
        region: IGeoRegion;
    };
}

/**
 * Блок фильтров
 */
export interface IHotelsFiltersBlock {
    type: EGeoRegionBlockType.HOTELS_FILTERS_BLOCK;
    data: {
        /**
         * Данные для построения фильтров
         */
        filterInfo: IFullFilters;
        /**
         * Параметры для формирования ссылки на страницу поиска
         */
        searchParams: ISearchPageIdentifyParams;
    };
}

export interface ISearchPageIdentifyParams {
    geoId?: GeoIdType;
    selectedSortId?: TSortId;
    filterParams?: IFilterParams;
}

/* Link blocks */
export interface IHotelLinkBlock {
    type: ETextBlocksType.hotelLinkBlock;
    data: {
        text: string;
        urlParams: {
            hotelSlug: HotelSlugType;
        };
    };
}

export interface IRegionLinkBlock {
    type: ETextBlocksType.regionLinkBlock;
    data: {
        text: string;
        urlParams: {
            regionSlug: TGeoRegionSlug;
            filterSlug?: string;
        };
    };
}

export interface ISearchHotelsLinkBlock {
    type: ETextBlocksType.searchHotelsLinkBlock;
    data: {
        text: string;
        urlParams: ISearchPageIdentifyParams;
    };
}

export interface IBreadcrumbsBlock {
    type: EGeoRegionBlockType.BREADCRUMBS_BLOCK;
    data: {
        breadcrumbs: IBreadcrumbs;
    };
}

/**
 * Блок ссылок на страницы региона с фильтрами. Отображается на странице региона без фильтра
 * На десктопе располагается в левой части
 */
export interface IRegionLinkSetBlock {
    type: EGeoRegionBlockType.REGION_LINK_SET_BLOCK;
    data: {
        /**
         * Заголовок h2
         */
        title: string;
        /**
         * Массив подгрупп ссылок. Не пустой
         */
        subsets: IRegionLinkSubSetBlock[];
    };
}

interface IRegionLinkSubSetBlock {
    type: EGeoRegionBlockType.REGION_LINK_SUB_SET_BLOCK;
    data: {
        /**
         * Заголовок h3
         */
        title: string;
        /**
         * Массив ссылок. Не пустой
         */
        links: IRegionLinkBlock[];
    };
}

/* Main */
export type TGeoRegionSlug = string;
export type TFilterSlug = string;
export type TGeoRegionBlock =
    | ISearchFormBlock
    | IHotelsBlock
    | IHotelsFiltersBlock
    | ISectionTextBlock
    | IBreadcrumbsBlock
    | IRegionLinkSetBlock
    | ICrossSaleHotelsBlock;

export enum EGeoRegionBlockType {
    SEARCH_FORM_BLOCK = 'ISearchFormBlock',
    HOTELS_BLOCK = 'IHotelsBlock',
    HOTELS_FILTERS_BLOCK = 'IHotelsFiltersBlock',
    BREADCRUMBS_BLOCK = 'IBreadcrumbsBlock',
    REGION_LINK_SET_BLOCK = 'IRegionLinkSetBlock',
    REGION_LINK_SUB_SET_BLOCK = 'IRegionLinkSubSetBlock',
}

export interface IGeoRegionInfo {
    seoInfo: IGeoRegionSeoInfo;
    blocks: TGeoRegionBlock[];
    extraVisitAndUserParams: IExtraVisitAndUserParams;
}
