import {HotelSlugType, PermalinkType} from 'types/hotels/hotel/IHotel';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export interface ILegacyHotel {
    id: string;
    name: string;
    address: string;
    country: string;
    image: string;
    permalink: PermalinkType;
    hotelSlug: HotelSlugType;
    price: ILegacyHotelPrice;
    stars: number;
    rating: number;
    searchUrl: string;
    features: string[];
}

export interface ILegacyHotelPrice {
    amount: number;
    type: 'MINIMUM' | 'MEDIAN';
    currency: CurrencyType;
}
